define([
    'underscore',
    'backbone',
    'models/singleton-collection',
], function(_, Backbone, Collection) {
    'use strict';

    var PatientIdentifier = Backbone.Model.extend({idAttribute: 'assigningAuthority'});

    return Collection.extend({
        resourceName: 'patient-identifiers',

        defaultsFetchOptions: {
            global: false,
            cache: false,
        },

        model: PatientIdentifier,

        hasDfnAndIcn: function() {
            var hasIcn = this.find(function(patientIdentifier) {
                return patientIdentifier.get('assigningAuthority').toUpperCase()
                    .indexOf('ICN') === 0;
            }) !== undefined;
            var hasDfn = this.find(function(patientIdentifier) {
                return patientIdentifier.get('assigningAuthority').toUpperCase()
                    .indexOf('DFN') === 0;
            }) !== undefined;

            return hasIcn && hasDfn;
        },
        hasNoIcn: function() {
            return (this.getIcnModel() === undefined);
        },
        getIcnModel: function() {
            return this.find(function(patientIdentifier) {
                return patientIdentifier.id.toUpperCase().indexOf('ICN') === 0;
            });
        },
        getDfnSiteCodes: function() {
            var siteCodes = [];
            var authorities = this.pluck('assigningAuthority');
            var authorityLength = 4;

            _.forEach(authorities, function(authority) {
                if (authority.indexOf('dfn-') === 0) {
                    siteCodes.push(authority.substring(authorityLength));
                }
            });

            return siteCodes;
        },
        parse: function(response) {
            var identifiers = [];
            if (response) {
                identifiers = response;
            }
            return identifiers;
        },
    });
});
